' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Partial Class ViewBug
    Inherits System.Web.UI.Page
  Private bugId As Integer = 0

  Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
    If Request.QueryString.Get("Id") IsNot Nothing Then
      bugId = Convert.ToInt32(Request.QueryString.Get("Id"))
    Else
      Response.Redirect("Default.aspx")
    End If

    If Not Page.IsPostBack Then
      LoadData()
    End If
  End Sub

  Private Sub LoadData()
    If (bugId > 0) Then
      Dim myBugManager As BugManager = New BugManager(Helpers.GetMemberId)
      Dim myBug As Bug = myBugManager.GetBug(bugId)
      If myBug IsNot Nothing Then
        ' Powi waciwoci bdu z kontrolkami formatki. Jeli uytkownik jest menederem lub programist
        ' moe modyfikowa kade pole. Jeli uytkownik peni inn rol, moe zmieni wycznie pole Opis, i to
        ' tylko wtedy, gdy on sam zglosi bd.
        lblFeature.Text = myBug.Feature.Name
        lblReproducibility.Text = myBug.Reproducibility.Name
        lblFrequency.Text = myBug.Frequency.Name
        lblSeverity.Text = myBug.Severity.Name
        lblPriority.Text = myBug.Priority.ToString()
        lblStatus.Text = myBug.Status.Name
        lblTitle.Text = myBug.Title
        lblDescription.Text = myBug.Description.Replace(ControlChars.CrLf, "<br />")
      Else
        Response.Redirect("Default.aspx")
      End If
    End If
  End Sub

End Class
